#ifndef YMDELTAT_H
#define YMDELTAT_H

#include "MSXTypes.h"


typedef struct {
	UInt8* ramBank;
    void* y8950;
	int ramSize;
	int startAddr;
	int stopAddr;
	int playAddr;
	int addrMask;
	int memPntr;
	int romBank;
	int playing;
	int volume;
    Int16 delta;
	UInt32 nowStep;
    UInt32 step;
	int out;
    int output;
	int diff;
	int nextLeveling;
	int sampleStep;
	int volumeWStep;
	UInt8 reg7;
	UInt8 reg15;
} Adpcm;

Adpcm* adpcmCreate(int ramSize, void* y8950, UInt32 systemTime);
void adpcmDestroy(Adpcm* adpcm);
void adpcmReset(Adpcm* adpcm, UInt32 systemTime);
void adpcmWriteReg(Adpcm* adpcm, UInt8 reg, UInt8 data, UInt32 systemTime);
UInt8 adpcmReadReg(Adpcm* adpcm, UInt8 reg);
int adpcmCalcSample(Adpcm* adpcm);

void adpcmSetStatus(void* y8950, UInt8 value);

#endif

